//===============================================================================
// Microsoft patterns & practices Enterprise Library
// Configuration Application Block
//===============================================================================
// Copyright  Microsoft Corporation.  All rights reserved.
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY
// OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT
// LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE.
//===============================================================================

using System.Configuration;
using Microsoft.VisualStudio.QualityTools.UnitTesting.Framework;

namespace Microsoft.Practices.EnterpriseLibrary.Configuration.Tests
{
	[TestClass]
	public class DictionarySourceFixture
	{
		[TestMethod]
		public void CanRetrieveSectionFromSource()
		{
			DictionaryConfigurationSource source = LocalConfigurationSource.Create();

			Assert.IsTrue(source.Contains("test"));
			Assert.IsInstanceOfType(source.GetSection("test"), typeof(LocalConfigurationSection));			
			Assert.IsTrue(source.Remove("test"));
			Assert.IsNull(source.GetSection("random"));
		}

		class LocalConfigurationSection : ConfigurationSection
		{
		}

		static class LocalConfigurationSource
		{
			public static DictionaryConfigurationSource Create()
			{
				DictionaryConfigurationSource source = new DictionaryConfigurationSource();
				source.Add("test", new LocalConfigurationSection());
				return source;
			}
		}
	}
}
